/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.harvesting;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class HoeHandler
extends ForgeRegistryEntry<HoeHandler>
implements Predicate<ItemStack> {
    private final Predicate<ItemStack> matchItem;
    private final BiConsumer<ItemStack, Player> useDurability;

    public HoeHandler(Predicate<ItemStack> matchItem, BiConsumer<ItemStack, Player> useDurability) {
        this.matchItem = matchItem;
        this.useDurability = useDurability;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.matchItem.test(stack);
    }

    public Consumer<Player> getConsumer(ItemStack stack) {
        return player -> this.useDurability.accept(stack, (Player)player);
    }

    public static class DefaultHoeHandler
    extends HoeHandler {
        public DefaultHoeHandler() {
            super(stack -> stack.m_41720_() instanceof HoeItem, (stack, player) -> stack.m_41622_(1, (LivingEntity)player, p -> {}));
        }
    }
}

